package com.ejie.ab04b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.constantes.Secuencias;
import com.ejie.ab04b.model.DatosLocalizacion;
import com.ejie.ab04b.model.DatosNotificacion;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab0466s00DaoImpl generated by UDA, 21-Feb-2017 12:47:21.
 * 
 * @author UDA
 */

@Repository()
@Transactional()
public class DatosNotificacionDaoImpl implements DatosNotificacionDao {

	private static final String QUERY_SELECT = "SELECT t1.COD_DATOS_NOTIF_066 CODDATOSNOTIF066, t1.IDIOMA_066 IDIOMA066, t1.CANALNOTIF_066 CANALNOTIF066, t1.COD_LOCALIZACION_066 CODLOCALIZACION066 FROM AB0466S00 t1 ";

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<DatosNotificacion> rwMap = new RowMapper<DatosNotificacion>() {
		public DatosNotificacion mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new DatosNotificacion(resultSet.getInt("CODDATOSNOTIF066"),
					resultSet.getString("IDIOMA066"),
					resultSet.getString("CANALNOTIF066"), new DatosLocalizacion(
							resultSet.getInt("CODLOCALIZACION066")));
		}
	};

	private RowMapper<DatosNotificacion> rwMapPK = new RowMapper<DatosNotificacion>() {
		public DatosNotificacion mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new DatosNotificacion(resultSet.getInt("CODDATOSNOTIF066"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 *  dataSource            DataSource
	 *
	 * @param dataSource the new data source
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Ab0466s00 table.
	 * 
	 *  ab0466s00
	 *            Ab0466s00
	 *  Ab0466s00
	 *
	 * @param ab0466s00 the ab 0466 s 00
	 * @return the datos notificacion
	 */
	public DatosNotificacion add(DatosNotificacion ab0466s00) {
		String query = "INSERT INTO AB0466S00 (COD_DATOS_NOTIF_066, COD_LOCALIZACION_066, IDIOMA_066, CANALNOTIF_066) VALUES (?,?,?,?)";

		ab0466s00.setCodDatosNotif066(
				Secuencias.DATOS_NOTIFICACION.getNextInteger(jdbcTemplate));

		Object getAb0467s00CodLocalizacion067Aux = null;
		if (ab0466s00.getDatosLocalizacion() != null && ab0466s00
				.getDatosLocalizacion().getCodLocalizacion067() != null) {
			getAb0467s00CodLocalizacion067Aux = ab0466s00.getDatosLocalizacion()
					.getCodLocalizacion067();
		}

		this.jdbcTemplate.update(query, ab0466s00.getCodDatosNotif066(),
				getAb0467s00CodLocalizacion067Aux, ab0466s00.getIdioma066(),
				ab0466s00.getCanalnotif066());
		return ab0466s00;
	}

	/**
	 * Updates a single row in the Ab0466s00 table.
	 * 
	 *  ab0466s00
	 *            Ab0466s00
	 *  Ab0466s00
	 *
	 * @param ab0466s00 the ab 0466 s 00
	 * @return the datos notificacion
	 */
	public DatosNotificacion update(DatosNotificacion ab0466s00) {
		String query = "UPDATE AB0466S00 SET COD_LOCALIZACION_066=?, IDIOMA_066=?, CANALNOTIF_066=? WHERE COD_DATOS_NOTIF_066=?";
		Object getAb0467s00CodLocalizacion067Aux = null;
		if (ab0466s00.getDatosLocalizacion() != null && ab0466s00
				.getDatosLocalizacion().getCodLocalizacion067() != null) {
			getAb0467s00CodLocalizacion067Aux = ab0466s00.getDatosLocalizacion()
					.getCodLocalizacion067();
		}
		this.jdbcTemplate.update(query, getAb0467s00CodLocalizacion067Aux,
				ab0466s00.getIdioma066(), ab0466s00.getCanalnotif066(),
				ab0466s00.getCodDatosNotif066());
		return ab0466s00;
	}

	/**
	 * Finds a single row in the Ab0466s00 table.
	 * 
	 *  ab0466s00
	 *            Ab0466s00
	 *  Ab0466s00
	 *
	 * @param ab0466s00 the ab 0466 s 00
	 * @return the datos notificacion
	 */
	@Transactional(readOnly = true)
	public DatosNotificacion find(DatosNotificacion ab0466s00) {
		StringBuilder query = new StringBuilder(
				DatosNotificacionDaoImpl.QUERY_SELECT);
		query.append(" WHERE t1.COD_DATOS_NOTIF_066 = ? ");

		List<DatosNotificacion> ab0466s00List = this.jdbcTemplate.query(
				query.toString(), this.rwMap, ab0466s00.getCodDatosNotif066());
		return (DatosNotificacion) DataAccessUtils.uniqueResult(ab0466s00List);
	}

	/**
	 * Removes a single row in the Ab0466s00 table.
	 * 
	 *  ab0466s00            Ab0466s00
	 *
	 * @param ab0466s00 the ab 0466 s 00
	 */
	public void remove(DatosNotificacion ab0466s00) {
		String query = "DELETE FROM AB0466S00 WHERE COD_DATOS_NOTIF_066=?";
		this.jdbcTemplate.update(query, ab0466s00.getCodDatosNotif066());
	}

	/**
	 * Finds a list of rows in the Ab0466s00 table.
	 * 
	 *  ab0466s00
	 *            Ab0466s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<Ab0466s00>
	 *
	 * @param ab0466s00 the ab 0466 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<DatosNotificacion> findAll(DatosNotificacion ab0466s00,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				DatosNotificacionDaoImpl.QUERY_SELECT);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab0466s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<DatosNotificacion>) this.jdbcTemplate
				.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Ab0466s00 table using like.
	 * 
	 *  ab0466s00
	 *            Ab0466s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<Ab0466s00>
	 *
	 * @param ab0466s00 the ab 0466 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<DatosNotificacion> findAllLike(DatosNotificacion ab0466s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				DatosNotificacionDaoImpl.QUERY_SELECT);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0466s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<DatosNotificacion>) this.jdbcTemplate
				.query(query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Ab0466s00 table.
	 * 
	 *  ab0466s00
	 *            Ab0466s00
	 *  Long
	 *
	 * @param ab0466s00 the ab 0466 s 00
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(DatosNotificacion ab0466s00) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0466S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab0466s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Ab0466s00 table using like.
	 * 
	 *  ab0466s00
	 *            Ab0466s00
	 *  startsWith
	 *            Boolean
	 *  Long
	 *
	 * @param ab0466s00 the ab 0466 s 00
	 * @param startsWith the starts with
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(DatosNotificacion ab0466s00,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0466S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0466s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Ab0466s00 selected for rup_table.
	 * 
	 *  ab0466s00            Ab0466s00
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *  List<TableRowDto<Ab0466s00>>
	 *
	 * @param ab0466s00 the ab 0466 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Override()
	public List<TableRowDto<DatosNotificacion>> reorderSelection(
			DatosNotificacion ab0466s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				DatosNotificacionDaoImpl.QUERY_SELECT);
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0466s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings(value = "unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, DatosNotificacion.class,
				filterParamList, "COD_DATOS_NOTIF_066");

		return this.jdbcTemplate
				.query(sbReorderSelectionSQL.toString(),
						new RowNumResultSetExtractor<DatosNotificacion>(
								this.rwMapPK, jqGridRequestDto),
						filterParamList.toArray());
	}

	/**
	 * Search method for rup_table.
	 * 
	 *  filterParams            Ab0466s00
	 *  searchParams            Ab0466s00
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *  List<TableRowDto<Ab0466s00>>
	 *
	 * @param filterParams the filter params
	 * @param searchParams the search params
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Override()
	public List<TableRowDto<DatosNotificacion>> search(
			DatosNotificacion filterParams, DatosNotificacion searchParams,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				DatosNotificacionDaoImpl.QUERY_SELECT);
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings(value = "unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(searchParams,
				startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings(value = "unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, DatosNotificacion.class,
				filterParamList, searchSQL, searchParamList, from_alias,
				"COD_DATOS_NOTIF_066");

		return this.jdbcTemplate
				.query(sbReorderSelectionSQL.toString(),
						new RowNumResultSetExtractor<DatosNotificacion>(
								this.rwMapPK, jqGridRequestDto),
						filterParamList.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab0466s00 entity.
	 * 
	 *  ab0466s00            Ab0466s00 Bean with the criteria values to filter by.
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param ab0466s00 the ab 0466 s 00
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(DatosNotificacion ab0466s00) {

		StringBuilder where = new StringBuilder(
				DatosNotificacionDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab0466s00 != null && ab0466s00.getCodDatosNotif066() != null) {
			where.append(" AND t1.COD_DATOS_NOTIF_066 = ?");
			params.add(ab0466s00.getCodDatosNotif066());
		}
		if (ab0466s00 != null && ab0466s00.getDatosLocalizacion() != null
				&& ab0466s00.getDatosLocalizacion()
						.getCodLocalizacion067() != null) {
			where.append(" AND t1.COD_LOCALIZACION_066 = ?");
			params.add(
					ab0466s00.getDatosLocalizacion().getCodLocalizacion067());
		}
		if (ab0466s00 != null && ab0466s00.getIdioma066() != null) {
			where.append(" AND t1.IDIOMA_066 = ?");
			params.add(ab0466s00.getIdioma066());
		}
		if (ab0466s00 != null && ab0466s00.getCanalnotif066() != null) {
			where.append(" AND t1.CANALNOTIF_066 = ?");
			params.add(ab0466s00.getCanalnotif066());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab0466s00 entity.
	 * 
	 *  ab0466s00            Ab0466s00 Bean with the criteria values to filter by.
	 *  startsWith            Boolean
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param ab0466s00 the ab 0466 s 00
	 * @param startsWith the starts with
	 * @return the where like map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(DatosNotificacion ab0466s00,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				DatosNotificacionDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab0466s00 != null && ab0466s00.getCodDatosNotif066() != null) {
			where.append(" AND t1.COD_DATOS_NOTIF_066 = ?");
			params.add(ab0466s00.getCodDatosNotif066());
		}
		if (ab0466s00 != null && ab0466s00.getDatosLocalizacion() != null
				&& ab0466s00.getDatosLocalizacion()
						.getCodLocalizacion067() != null) {
			where.append(" AND t1.COD_LOCALIZACION_066 = ?");
			params.add(
					ab0466s00.getDatosLocalizacion().getCodLocalizacion067());
		}
		if (ab0466s00 != null && ab0466s00.getIdioma066() != null) {
			where.append(" AND UPPER(t1.IDIOMA_066) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0466s00.getIdioma066().toUpperCase() + "%");
			} else {
				params.add("%" + ab0466s00.getIdioma066().toUpperCase() + "%");
			}
			where.append(" AND t1.IDIOMA_066 IS NOT NULL");
		}
		if (ab0466s00 != null && ab0466s00.getCanalnotif066() != null) {
			where.append(" AND UPPER(t1.CANALNOTIF_066) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0466s00.getCanalnotif066().toUpperCase() + "%");
			} else {
				params.add(
						"%" + ab0466s00.getCanalnotif066().toUpperCase() + "%");
			}
			where.append(" AND t1.CANALNOTIF_066 IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
